/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1993  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/
/*

LIBRARY        : alteralib; Rev 1.0; February 93
FUNCTION       : 8-BIT ADDRESSABLE LATCHES 
TRUTHTABLE     : 

          -----------------------------------         ---------------------------------    
           CLR_   G_   OUTPUT OF    OUTPUT OF

                       ADDRESSED     OTHER          S2  S1  S0      LATCH ADDRESSED
                         LATCH      LATCHES
          ---------------------------------          -----------------------------------
        					     L   L   L           0
           H      L        D          Qio            L   L   H           1
                                                     L   H   L           2
           H      H        Qio        Qio            L   H   H           3
                                                     H   L   L           4
           L      L        D          L              H   L   H           5
                                                     H   H   L           6
           L      H        L          L              H   H   H           7
          -----------------------------------      ---------------------------------  

   Note : 1. D = the level of data INPUT :
          2. Qio = the level of Qi (i = 0, .. 7) before the indicated
             steady state INPUT :conditions were established. 

REFERENCE      : Altera MAX+Plus II online help, component description
DESIGNER       : AMI VIDER
DATE GENERATED : February 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module a259 (s0, s1, s2, q0, q1, q2, q3, q4, q5, q6, q7, d, gn, clrn);
	parameter size =1;
	parameter cds_action = "ignore";
	input
		d,
		clrn,
		s0,
		s1,
		s2,
		gn;
	output
		q0,
		q1,
		q2,
		q3,
		q4,
		q5,
		q6,
		q7;
    reg
        NOTIFY_REG;
    not
	MSIG_259_inst_N0 (msig_259_inst_ns0, s0);
    not
	MSIG_259_inst_N1 (msig_259_inst_ns1, s1);
    not
	MSIG_259_inst_N2 (msig_259_inst_ns2, s2);
    not
	MSIG_259_inst_N3 (msig_259_inst_ngb, gn);
    U_NOTI  
	MSIG_259_inst_inst10 (q0, msig_259_inst_q0_i, NOTIFY_REG);
    U_NOTI  
	MSIG_259_inst_inst11 (q1, msig_259_inst_q1_i, NOTIFY_REG);
    U_NOTI  
	MSIG_259_inst_inst12 (q2, msig_259_inst_q2_i, NOTIFY_REG);
    U_NOTI  
	MSIG_259_inst_inst13 (q3, msig_259_inst_q3_i, NOTIFY_REG);
    U_NOTI  
	MSIG_259_inst_inst14 (q4, msig_259_inst_q4_i, NOTIFY_REG);
    U_NOTI  
	MSIG_259_inst_inst15 (q5, msig_259_inst_q5_i, NOTIFY_REG);
    U_NOTI  
	MSIG_259_inst_inst16 (q6, msig_259_inst_q6_i, NOTIFY_REG);
    U_NOTI  
	MSIG_259_inst_inst17 (q7, msig_259_inst_q7_i, NOTIFY_REG);
    and
	MSIG_259_inst_INST1_A1 (msig_259_inst_inst1_wa1, msig_259_inst_ns0, msig_259_inst_ns1, msig_259_inst_ns2, msig_259_inst_ngb, d);
    and
	MSIG_259_inst_INST1_A2 (msig_259_inst_inst1_wa2, msig_259_inst_inst1_wnd1, clrn, msig_259_inst_q0_i);
    nand
	MSIG_259_inst_INST1_ND1 (msig_259_inst_inst1_wnd1, msig_259_inst_ns0, msig_259_inst_ns1, msig_259_inst_ns2, msig_259_inst_ngb);
    or
	MSIG_259_inst_INST1_R1 (msig_259_inst_q0_i, msig_259_inst_inst1_wa1, msig_259_inst_inst1_wa2);
    and
	MSIG_259_inst_INST2_A1 (msig_259_inst_inst2_wa1, s0, msig_259_inst_ns1, msig_259_inst_ns2, msig_259_inst_ngb, d);
    and
	MSIG_259_inst_INST2_A2 (msig_259_inst_inst2_wa2, msig_259_inst_inst2_wnd1, clrn, msig_259_inst_q1_i);
    nand
	MSIG_259_inst_INST2_ND1 (msig_259_inst_inst2_wnd1, s0, msig_259_inst_ns1, msig_259_inst_ns2, msig_259_inst_ngb);
    or
	MSIG_259_inst_INST2_R1 (msig_259_inst_q1_i, msig_259_inst_inst2_wa1, msig_259_inst_inst2_wa2);
    and
	MSIG_259_inst_INST3_A1 (msig_259_inst_inst3_wa1, msig_259_inst_ns0, s1, msig_259_inst_ns2, msig_259_inst_ngb, d);
    and
	MSIG_259_inst_INST3_A2 (msig_259_inst_inst3_wa2, msig_259_inst_inst3_wnd1, clrn, msig_259_inst_q2_i);
    nand
	MSIG_259_inst_INST3_ND1 (msig_259_inst_inst3_wnd1, msig_259_inst_ns0, s1, msig_259_inst_ns2, msig_259_inst_ngb);
    or
	MSIG_259_inst_INST3_R1 (msig_259_inst_q2_i, msig_259_inst_inst3_wa1, msig_259_inst_inst3_wa2);
    and
	MSIG_259_inst_INST4_A1 (msig_259_inst_inst4_wa1, s0, s1, msig_259_inst_ns2, msig_259_inst_ngb, d);
    and
	MSIG_259_inst_INST4_A2 (msig_259_inst_inst4_wa2, msig_259_inst_inst4_wnd1, clrn, msig_259_inst_q3_i);
    nand
	MSIG_259_inst_INST4_ND1 (msig_259_inst_inst4_wnd1, s0, s1, msig_259_inst_ns2, msig_259_inst_ngb);
    or
	MSIG_259_inst_INST4_R1 (msig_259_inst_q3_i, msig_259_inst_inst4_wa1, msig_259_inst_inst4_wa2);
    and
	MSIG_259_inst_INST5_A1 (msig_259_inst_inst5_wa1, msig_259_inst_ns0, msig_259_inst_ns1, s2, msig_259_inst_ngb, d);
    and
	MSIG_259_inst_INST5_A2 (msig_259_inst_inst5_wa2, msig_259_inst_inst5_wnd1, clrn, msig_259_inst_q4_i);
    nand
	MSIG_259_inst_INST5_ND1 (msig_259_inst_inst5_wnd1, msig_259_inst_ns0, msig_259_inst_ns1, s2, msig_259_inst_ngb);
    or
	MSIG_259_inst_INST5_R1 (msig_259_inst_q4_i, msig_259_inst_inst5_wa1, msig_259_inst_inst5_wa2);
    and
	MSIG_259_inst_INST6_A1 (msig_259_inst_inst6_wa1, s0, msig_259_inst_ns1, s2, msig_259_inst_ngb, d);
    and
	MSIG_259_inst_INST6_A2 (msig_259_inst_inst6_wa2, msig_259_inst_inst6_wnd1, clrn, msig_259_inst_q5_i);
    nand
	MSIG_259_inst_INST6_ND1 (msig_259_inst_inst6_wnd1, s0, msig_259_inst_ns1, s2, msig_259_inst_ngb);
    or
	MSIG_259_inst_INST6_R1 (msig_259_inst_q5_i, msig_259_inst_inst6_wa1, msig_259_inst_inst6_wa2);
    and
	MSIG_259_inst_INST7_A1 (msig_259_inst_inst7_wa1, msig_259_inst_ns0, s1, s2, msig_259_inst_ngb, d);
    and
	MSIG_259_inst_INST7_A2 (msig_259_inst_inst7_wa2, msig_259_inst_inst7_wnd1, clrn, msig_259_inst_q6_i);
    nand
	MSIG_259_inst_INST7_ND1 (msig_259_inst_inst7_wnd1, msig_259_inst_ns0, s1, s2, msig_259_inst_ngb);
    or
	MSIG_259_inst_INST7_R1 (msig_259_inst_q6_i, msig_259_inst_inst7_wa1, msig_259_inst_inst7_wa2);
    and
	MSIG_259_inst_INST8_A1 (msig_259_inst_inst8_wa1, s0, s1, s2, msig_259_inst_ngb, d);
    and
	MSIG_259_inst_INST8_A2 (msig_259_inst_inst8_wa2, msig_259_inst_inst8_wnd1, clrn, msig_259_inst_q7_i);
    nand
	MSIG_259_inst_INST8_ND1 (msig_259_inst_inst8_wnd1, s0, s1, s2, msig_259_inst_ngb);
    or
	MSIG_259_inst_INST8_R1 (msig_259_inst_q7_i, msig_259_inst_inst8_wa1, msig_259_inst_inst8_wa2);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam Area = 1;
`endif



    endspecify

endmodule
`endcelldefine
